#include <Blobs/StdV3D.h>

#include "BoundAabb.h"

namespace V3D {

	
////////////////////////////////////////////////////////////////////////////////

void BoundAabb::Build(const Vect3DArray& aVertices, const TriangleArray& aTriangles)
{
	// Calcul des vertices utilises par les triangles 
	Vect3DArray::size_type   nVertexCount   = aVertices.size();
	
	Vect3DArray	aPointCloud;
	aPointCloud.reserve( nVertexCount);
	
	std::vector<bool> abUsedVertex( nVertexCount, false);

	typedef TriangleArray::const_iterator TriIter;
	TriIter itEnd = aTriangles.end();
	for( TriIter it = aTriangles.begin(); it != itEnd; ++it)
	{
		abUsedVertex[ it->a ] = true;
		abUsedVertex[ it->b ] = true;
		abUsedVertex[ it->c ] = true;
	}

	for( Vect3DArray::size_type i = 0; i < nVertexCount; ++i)
	{
		if( abUsedVertex[i] )
			aPointCloud.push_back( aVertices[i] );
	}

	Build( aPointCloud);
}




void BoundAabb::Build(const Vect3DArray& aPointCloud)
{
	// Nuage vide ?
	int32 nPointsCount = aPointCloud.size();
	if( nPointsCount == 0)
	{
		m_vcMin.Set( 0.f, 0.f, 0.f);
		m_vcMax.Set( 0.f, 0.f, 0.f);
		return;	
	}

	const Vector3D& vcPt0 = aPointCloud[0];

	Vector3D vcMin = vcPt0;
	Vector3D vcMax = vcPt0;
	
	for( int32 i = 1; i < nPointsCount; ++i)
	{
		const Vector3D& vcCurPt = aPointCloud[i];
		if( vcMin.x > vcCurPt.x) vcMin.x = vcCurPt.x;
		if( vcMin.y > vcCurPt.y) vcMin.y = vcCurPt.y;
		if( vcMin.z > vcCurPt.z) vcMin.z = vcCurPt.z;
		if( vcMax.x < vcCurPt.x) vcMax.x = vcCurPt.x;
		if( vcMax.y < vcCurPt.y) vcMax.y = vcCurPt.y;
		if( vcMax.z < vcCurPt.z) vcMax.z = vcCurPt.z;
	}

	m_vcMin = vcMin;
	m_vcMax = vcMax;
}

BoundAabb BoundAabb::Union(const BoundAabb& box1, const BoundAabb& box2)
{
	BoundAabb boxRes = box1;
	boxRes.Merge(box2);
	return boxRes;
}

void BoundAabb::GetVertices( Vector3D aObbVerts[8]) const
{
	aObbVerts[0].Set( m_vcMin.x, m_vcMin.y, m_vcMin.z  );
	aObbVerts[1].Set( m_vcMax.x, m_vcMin.y, m_vcMin.z  );
	aObbVerts[2].Set( m_vcMax.x, m_vcMax.y, m_vcMin.z  );
	aObbVerts[3].Set( m_vcMin.x, m_vcMax.y, m_vcMin.z  );

	aObbVerts[4].Set( m_vcMin.x, m_vcMin.y, m_vcMax.z  );
	aObbVerts[5].Set( m_vcMax.x, m_vcMin.y, m_vcMax.z  );
	aObbVerts[6].Set( m_vcMax.x, m_vcMax.y, m_vcMax.z  );
	aObbVerts[7].Set( m_vcMin.x, m_vcMax.y, m_vcMax.z  );
}


} // namespaces


